﻿<%@ import Namespace="System.Diagnostics" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Kalend" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Lista osób przekraczających próg urlopowy</title>
		<script runat="server">

    public class Params: ContextBase {    
        public Params(Context context): base(context) {
            Date data = ((ActualDate)Context[typeof(ActualDate)]).Actual;
            rok = data.Year;
        }
    
        int rok;
        [Required]
        [Caption("Raport za rok")]
        [Priority(1)]
        public int Rok {
            get { return rok; }
            set {
                rok = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }
        
    Params pars;
    [Context]
    public Params Pars {
        set { pars = value; }
    }

    private LimitNieobecnosci LimitUrlopowy(Pracownik prac) {
        FromTo year = FromTo.Year(pars.Rok);
        Date from = Date.Empty;
        
        StazPracy razem = prac.StażPracy(RodzajPodstawyStażuPracy.StazDoUrlopu);
        StazPracy początek = (prac.StażPracy(year.From - 1) + razem).Normalizuj();
        StazPracy koniec = (prac.StażPracy(year.To) + razem).Normalizuj();
        if (początek.Lata != 9 || koniec.Lata != 10)
            return null;

        foreach (Date data in year) {
            StazPracy st = (prac.StażPracy(data) + razem).Normalizuj();
            if (st.Lata == 10) {
                from = data;
                break;
            }
        }
        if (from == Date.Empty)
            return null;
        
        KalendModule kalend = KalendModule.GetInstance(dc);
        DefinicjaLimitu definicja = kalend.DefinicjeLimitow.UrlopWypoczynkowy;
        IEnumerable limity = kalend.LimNieobecnosci.WgPracownik[prac, definicja][year];
        foreach (LimitNieobecnosci l in limity)
            if (l.Okres.From == from)
                return l;
        
        return null;
    }
            
    void OnContextLoad(Object sender, EventArgs e) {
		ReportHeader1["ROK"] = pars.Rok.ToString();
		
        ArrayList lista = new ArrayList();
		LimitNieobecnosci limit;
        
        Row[] rows = (Row[])dc[typeof(Row[])];
		foreach (Pracownik idx in rows) {
            limit = LimitUrlopowy(idx);
            if (limit != null)
                lista.Add(limit);
		}
		
		Grid1.DataSource = lista;
    }
    
    void Grid1_BeforeRow(Object sender, RowEventArgs args) {
        LimitNieobecnosci limit = (LimitNieobecnosci)args.Row;
        colNazwisko.EditValue = limit.Pracownik.NazwiskoImię;
        colUrlop.EditValue = limit.Okres.From;
	}
    
    static void Msg(object value) {
    }

		</script>
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="ProgUrlopowy" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" TypeName="Soneta.Business.Row[], Soneta.Business" oncontextload="OnContextLoad"></ea:datacontext>
            <cc1:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="Lista osób przekraczających próg urlopowy w %ROK% roku" runat="server"></cc1:reportheader>
            <ea:grid id="Grid1" runat="server" OnBeforeRow="Grid1_BeforeRow">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="Lp."></ea:GridColumn>
					<ea:GridColumn ID="colNazwisko" Caption="Nazwisko i imię"></ea:GridColumn>
					<ea:GridColumn Width="30" Align="Right" ID="colUrlop" Caption="Urlop uzupełniający od dnia"></ea:GridColumn>
				</Columns>
			</ea:grid>
            <cc1:reportfooter id="ReportFooter1" runat="server" TheEnd="False"></cc1:reportfooter>
        </form>
	</body>
</HTML>

